<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('website_id')->unsigned();
			$table->string('photo')->nullable();
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('uuid')->nullable();
			$table->longText('about_me')->nullable();
			$table->timestamps();
			$table->string('company')->nullable();
			$table->string('gender')->nullable();
			$table->string('phone')->nullable();
			$table->string('mobile')->nullable();
			$table->string('work')->nullable();
			$table->string('other')->nullable();
			$table->boolean('is_published')->default(1);
			$table->boolean('is_active')->default(1);
			$table->date('dob')->nullable();
			$table->string('skypeid')->nullable();
			$table->string('githubid')->nullable();
			$table->string('twitter_username')->nullable();
			$table->string('instagram_username')->nullable();
			$table->string('facebook_username')->nullable();
			$table->string('facebook_url')->nullable();
			$table->string('linked_in_url')->nullable();
			$table->string('google_plus_url')->nullable();
			$table->string('slug')->nullable();
			$table->integer('user_id')->unsigned();
			$table->string('display_name')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}