<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('customer_name');
			$table->integer('phone_no');
			$table->string('email');
			$table->string('password');
			$table->enum('status', array('1', '2'));
			$table->integer('loyalty_points');
			$table->enum('delete_status', array('1', '0'));
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}