<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentsTable extends Migration {

	public function up()
	{
		Schema::create('attachments', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('owner_type')->index();
			$table->bigInteger('owner_id')->unsigned()->index();
			$table->string('url');
			$table->string('type');
			$table->string('size');
		});
	}

	public function down()
	{
		Schema::drop('attachments');
	}
}