<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSolutionsTable extends Migration {

	public function up()
	{
		Schema::create('solutions', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('return_id')->unsigned()->index();
			$table->string('type');
			$table->integer('user_id');
			$table->string('state')->index();
			$table->boolean('need_return')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('solutions');
	}
}