<?php

namespace App\Models;

class Diploma extends Eloquent {

	protected $table = 'diplomas';
	public $timestamps = true;

	public function enrollments()
	{
		return $this->hasMany('App\Models\Enrollment');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

	public function semesters()
	{
		return $this->hasMany('App\Models\Semester');
	}

	public function users()
	{
		return $this->belongsToMany('App\Models\User');
	}

	public function comments()
	{
		return $this->hasMany('App\Models\Comment');
	}

	public function rates()
	{
		return $this->belongsToMany('App\Models\Rates');
	}

	public function exams()
	{
		return $this->morphToMany('App\Models\Exam', 'examable');
	}

	public function certificates()
	{
		return $this->hasMany('App\Models\Certificate');
	}

}