<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function enrollments()
	{
		return $this->hasMany('App\Models\Enrollment');
	}

	public function certificates()
	{
		return $this->hasMany('App\Models\Certificate');
	}

	public function exams()
	{
		return $this->belongsToMany('App\Models\UserExam');
	}

	public function diplomas()
	{
		return $this->belongsToMany('App\Models\Diploma');
	}

	public function comments()
	{
		return $this->hasMany('App\Models\Comment');
	}

	public function payments()
	{
		return $this->hasMany('App\Models\Payment');
	}

	public function cobones()
	{
		return $this->hasMany('App\Models\Cobone');
	}

}