<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVacationsTable extends Migration {

	public function up()
	{
		Schema::create('vacations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('vacation_type_id')->unsigned();
			$table->integer('employee_id');
			$table->date('strat_date');
			$table->date('end_date');
			$table->text('note')->nullable();
			$table->enum('alter_employee_status', array(''));
			$table->text('reject_resone')->nullable();
			$table->string('vacation_number');
			$table->enum('final_status', array(''));
			$table->timestamps();
			$table->timestamp('hr_action_at')->nullable();
			$table->timestamp('manager_action_at')->nullable();
			$table->timestamp('alter_employee_action_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('vacations');
	}
}