<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAmigosTable extends Migration {

	public function up()
	{
		Schema::create('amigos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('nombre', 60);
			$table->string('email', 60)->unique();
			$table->string('telefono', 15);
			$table->boolean('valido')->default(false);
			$table->integer('user_id')->unsigned()->nullable()->default('null');
		});
	}

	public function down()
	{
		Schema::drop('amigos');
	}
}