<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePremiosTable extends Migration {

	public function up()
	{
		Schema::create('premios', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('imagen')->default('default.jpg');
			$table->string('description', 255)->default('No description available');
			$table->tinyInteger('friends')->unsigned()->default('0');
			$table->smallInteger('stock')->unsigned()->default('0');
			$table->boolean('news')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('premios');
	}
}