<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('phone')->unique();
			$table->string('password');
			$table->tinyInteger('status')->default('0');
			$table->enum('login_type', array('apple', 'google', 'facebook'))->nullable();
			$table->datetime('login_date')->nullable();
			$table->datetime('last_login_date')->nullable();
			$table->string('app_login_count')->nullable();
			$table->string('site_login_count')->nullable();
			$table->datetime('email_verified_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}