<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->integer('chapter_id');
			$table->tinyInteger('is_active')->default('0');
			$table->integer('order')->nullable();
			$table->enum('type', array('card', 'quiz', 'video', 'pdf'));
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}