<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Representative extends Model 
{

    protected $table = 'representatives';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function place()
    {
        return $this->hasOne('Place', 'fk_place_id');
    }

    public function position()
    {
        return $this->belongsTo('Position', 'fk_position_id');
    }

}