<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('networks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('network_maincoor', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('network_maincoor', function(Blueprint $table) {
			$table->foreign('maincoor_id')->references('id')->on('maincoors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('networks', function(Blueprint $table) {
			$table->dropForeign('networks_user_id_foreign');
		});
		Schema::table('network_maincoor', function(Blueprint $table) {
			$table->dropForeign('network_maincoor_user_id_foreign');
		});
		Schema::table('network_maincoor', function(Blueprint $table) {
			$table->dropForeign('network_maincoor_maincoor_id_foreign');
		});
	}
}