<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 50);
			$table->string('email', 100);
			$table->date('birth_date');
			$table->integer('blood_type_id');
			$table->string('phone', 14);
			$table->string('password', 150);
			$table->string('code', 10);
			$table->string('api_token', 60)->unique()->nullable();
			$table->integer('city_id');
			$table->integer('government_id');
			$table->string('remember_token', 100);
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}