<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserBankTable extends Migration {

	public function up()
	{
		Schema::create('user_bank', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->string('account_no', 40)->unique();
			$table->string('ifsc', 30);
			$table->string('bank_name', 120);
			$table->string('account_holder_name', 150);
			$table->string('branch', 255);
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_bank');
	}
}