<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWithdrawalRequestTable extends Migration {

	public function up()
	{
		Schema::create('withdrawal_request', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('profile_id', 120)->unique();
			$table->string('req_cvamount', 20);
			$table->string('total_amount', 20)->nullable();
			$table->datetime('req_datetime')->nullable();
			$table->string('req_ip', 60)->nullable();
			$table->enum('req_status', array('Pending', 'Cancelled', 'Sent', 'Decline'));
			$table->enum('req_type', array('UserWallet', 'VideoWallet'));
			$table->string('decline_reason', 255)->nullable();
			$table->datetime('approved_date')->nullable();
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('withdrawal_request');
	}
}