<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUpgradePlanTable extends Migration {

	public function up()
	{
		Schema::create('upgrade_plan', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('basic_plan_id')->unsigned();
			$table->string('plan_name', 20);
			$table->integer('video_count');
			$table->bigInteger('video_amount');
			$table->enum('status', array('active', 'deactive'));
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('upgrade_plan');
	}
}