<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('category_id')->unsigned();
			$table->string('title');
			$table->text('description');
			$table->string('image')->nullable();
			$table->timestamps();
			$table->integer('views_count')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}