<?php

namespace App/Models;

class Blog extends Eloquent {

	protected $table = 'blogs';
	public $timestamps = true;
	protected $fillable = array('image', 'views_count');

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function comments()
	{
		return $this->hasMany('BlogComment', 'blog_id');
	}

}