<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTrackingTable extends Migration {

	public function up()
	{
		Schema::create('user_tracking', function(Blueprint $table) {
			$table->uuid('id');
			$table->datetime('day');
			$table->string('user_id');
			$table->string('category_id');
			$table->string('sub_category_id')->nullable();
			$table->string('inner_category_id')->nullable();
			$table->timestamps();
			$table->string('tracking_values');
			$table->string('comments')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_tracking');
	}
}