<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->uuid('id')->primary();
			$table->string('name', 255);
			$table->string('email', 255)->nullable();
			$table->date('dob')->nullable();
			$table->string('country', 255);
			$table->string('gender', 255);
			$table->enum('gi_same', array('yes', 'no'));
			$table->timestamps();
			$table->softDeletes();
			$table->string('roles');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}