<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmpresasTable extends Migration {

	public function up()
	{
		Schema::create('empresas', function(Blueprint $table) {
			$table->increments('empresas_id');
			$table->integer('contatos_id')->unsigned();
			$table->integer('users_id')->unsigned();
			$table->string('razao_social', 100);
			$table->string('cnpj', 14);
			$table->string('responsavel_nome', 100);
			$table->string('responsavel_cpf', 20);
			$table->boolean('ativo')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('empresas');
	}
}