<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Empresas extends Model 
{

    protected $table = 'empresas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('razao_social', 'cnpj', 'responsavel_nome', 'responsavel_cpf', 'ativo');

    public function user()
    {
        return $this->belongsTo('User', 'users_id');
    }

    public function contato()
    {
        return $this->hasOne('Contatos', 'contatos_id');
    }

    public function promocoes()
    {
        return $this->hasMany('Promocoes', 'promocoes_id');
    }

    public function turmas()
    {
        return $this->hasMany('Turmas', 'turmas_id');
    }

    public function clientes()
    {
        return $this->hasMany('Clientes', 'clientes_id');
    }

}