<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Professores extends Model 
{

    protected $table = 'professores';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nome', 'cpf', 'rg', 'ativo');

    public function contato()
    {
        return $this->hasOne('Contatos', 'contatos_id');
    }

    public function turmas()
    {
        return $this->hasMany('Turmas', 'turmas_id');
    }

}