<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Turmas extends Model 
{

    protected $table = 'turmas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nome', 'ativo', 'empresas_id');

    public function aulas()
    {
        return $this->hasMany('Aulas', 'aulas_id');
    }

    public function matriculas()
    {
        return $this->hasMany('Matriculas', 'matriculas_id');
    }

    public function empresa()
    {
        return $this->belongsTo('Empresas', 'empresas_id');
    }

    public function professor()
    {
        return $this->belongsTo('Professores', 'professores_id');
    }

}