<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePromocoesTable extends Migration {

	public function up()
	{
		Schema::create('promocoes', function(Blueprint $table) {
			$table->increments('promocoes_id');
			$table->integer('empresas_id')->unsigned();
			$table->string('nome', 60);
			$table->string('premio', 255);
			$table->decimal('valor_cupom', 15,2)->nullable();
			$table->datetime('data_inicial');
			$table->datetime('data_final');
			$table->datetime('sorteio_data_inicial')->nullable();
			$table->datetime('sorteio_data_final')->nullable();
			$table->boolean('ativo')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('promocoes');
	}
}