<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConversationsTable extends Migration {

	public function up()
	{
		Schema::create('conversations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->boolean('status')->default(0);
			$table->bigInteger('start_interaction_id');
			$table->bigInteger('intent_id')->nullable();
			$table->bigInteger('bot_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('conversations');
	}
}