<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInteractionIntegrationsTable extends Migration {

	public function up()
	{
		Schema::create('interaction_integrations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->string('url');
			$table->string('type_method')->nullable();
			$table->string('body_variables')->nullable();
			$table->json('request_headers')->nullable();
			$table->json('request_parameters')->nullable();
			$table->json('response_fields')->nullable();
			$table->bigInteger('interaction_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('interaction_integrations');
	}
}