<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInteractionLocationsTable extends Migration {

	public function up()
	{
		Schema::create('interaction_locations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name')->nullable();
			$table->string('address')->nullable();
			$table->float('lat', 10,6)->nullable();
			$table->float('lng', 10,6)->nullable();
			$table->string('type')->nullable();
			$table->bigInteger('interaction_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('interaction_locations');
	}
}