<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInteractionOptionsTable extends Migration {

	public function up()
	{
		Schema::create('interaction_options', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->json('text')->nullable();
			$table->string('value');
			$table->bigInteger('goto_interaction_id')->nullable();
			$table->bigInteger('interaction_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('interaction_options');
	}
}