<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourseReviewsTable extends Migration {

	public function up()
	{
		Schema::create('course_reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('rate')->nullable();
			$table->longText('comment')->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('course_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('course_reviews');
	}
}