<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar', 255)->unique()->nullable();
			$table->string('name_en', 255)->unique()->nullable();
			$table->integer('video_hosting');
			$table->string('video_url', 255)->nullable();
			$table->string('video_file', 255)->nullable();
			$table->string('description_ar', 255)->nullable();
			$table->string('description_en')->nullable();
			$table->string('resources', 255)->nullable();
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}