<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('course_chapters', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_chapters', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapters')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_sections', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_sections', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_reviews', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('main_section_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('sub_section_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->foreign('chapter_id')->references('id')->on('chapters')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certificates', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_certificates', function(Blueprint $table) {
			$table->foreign('exam_id')->references('id')->on('exams')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('user_certificates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('training_needs', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('training_needs', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('training_plans', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('nominations', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('nominations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('nominations', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('external_trainings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('external_trainings', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mandatory_lectures', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('mandatory_lectures', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('lecture_schedules', function(Blueprint $table) {
			$table->foreign('mandatory_lecture_id')->references('id')->on('mandatory_lectures')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cooperative_trainings', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cooperative_training_requests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cooperative_training_requests', function(Blueprint $table) {
			$table->foreign('cooperative_training_id')->references('id')->on('cooperative_trainings')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('co_request_need_traning', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('co_request_need_traning', function(Blueprint $table) {
			$table->foreign('hr_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('co_aplications', function(Blueprint $table) {
			$table->foreign('co_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('co_aplications', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('co_aplications', function(Blueprint $table) {
			$table->foreign('co_traning_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_role_id_foreign');
		});
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_department_id_foreign');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->dropForeign('departments_parent_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_department_id_foreign');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->dropForeign('user_details_user_id_foreign');
		});
		Schema::table('course_chapters', function(Blueprint $table) {
			$table->dropForeign('course_chapters_course_id_foreign');
		});
		Schema::table('course_chapters', function(Blueprint $table) {
			$table->dropForeign('course_chapters_chapter_id_foreign');
		});
		Schema::table('course_sections', function(Blueprint $table) {
			$table->dropForeign('course_sections_course_id_foreign');
		});
		Schema::table('course_sections', function(Blueprint $table) {
			$table->dropForeign('course_sections_section_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_parent_id_foreign');
		});
		Schema::table('course_reviews', function(Blueprint $table) {
			$table->dropForeign('course_reviews_user_id_foreign');
		});
		Schema::table('course_reviews', function(Blueprint $table) {
			$table->dropForeign('course_reviews_course_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_main_section_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_sub_section_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_user_id_foreign');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->dropForeign('course_lessons_course_id_foreign');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->dropForeign('course_lessons_chapter_id_foreign');
		});
		Schema::table('course_lessons', function(Blueprint $table) {
			$table->dropForeign('course_lessons_lesson_id_foreign');
		});
		Schema::table('exams', function(Blueprint $table) {
			$table->dropForeign('exams_course_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_question_id_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_course_id_foreign');
		});
		Schema::table('user_certificates', function(Blueprint $table) {
			$table->dropForeign('user_certificates_course_id_foreign');
		});
		Schema::table('user_certificates', function(Blueprint $table) {
			$table->dropForeign('user_certificates_exam_id_foreign');
		});
		Schema::table('user_certificates', function(Blueprint $table) {
			$table->dropForeign('user_certificates_user_id_foreign');
		});
		Schema::table('training_needs', function(Blueprint $table) {
			$table->dropForeign('training_needs_course_id_foreign');
		});
		Schema::table('training_needs', function(Blueprint $table) {
			$table->dropForeign('training_needs_department_id_foreign');
		});
		Schema::table('training_plans', function(Blueprint $table) {
			$table->dropForeign('training_plans_course_id_foreign');
		});
		Schema::table('nominations', function(Blueprint $table) {
			$table->dropForeign('nominations_course_id_foreign');
		});
		Schema::table('nominations', function(Blueprint $table) {
			$table->dropForeign('nominations_user_id_foreign');
		});
		Schema::table('nominations', function(Blueprint $table) {
			$table->dropForeign('nominations_department_id_foreign');
		});
		Schema::table('external_trainings', function(Blueprint $table) {
			$table->dropForeign('external_trainings_user_id_foreign');
		});
		Schema::table('external_trainings', function(Blueprint $table) {
			$table->dropForeign('external_trainings_department_id_foreign');
		});
		Schema::table('mandatory_lectures', function(Blueprint $table) {
			$table->dropForeign('mandatory_lectures_user_id_foreign');
		});
		Schema::table('mandatory_lectures', function(Blueprint $table) {
			$table->dropForeign('mandatory_lectures_department_id_foreign');
		});
		Schema::table('lecture_schedules', function(Blueprint $table) {
			$table->dropForeign('lecture_schedules_mandatory_lecture_id_foreign');
		});
		Schema::table('cooperative_trainings', function(Blueprint $table) {
			$table->dropForeign('cooperative_trainings_department_id_foreign');
		});
		Schema::table('cooperative_training_requests', function(Blueprint $table) {
			$table->dropForeign('cooperative_training_requests_user_id_foreign');
		});
		Schema::table('cooperative_training_requests', function(Blueprint $table) {
			$table->dropForeign('cooperative_training_requests_cooperative_training_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_user_id_foreign');
		});
		Schema::table('co_request_need_traning', function(Blueprint $table) {
			$table->dropForeign('co_request_need_traning_department_id_foreign');
		});
		Schema::table('co_request_need_traning', function(Blueprint $table) {
			$table->dropForeign('co_request_need_traning_hr_id_foreign');
		});
		Schema::table('co_aplications', function(Blueprint $table) {
			$table->dropForeign('co_aplications_co_user_id_foreign');
		});
		Schema::table('co_aplications', function(Blueprint $table) {
			$table->dropForeign('co_aplications_department_id_foreign');
		});
		Schema::table('co_aplications', function(Blueprint $table) {
			$table->dropForeign('co_aplications_co_traning_id_foreign');
		});
	}
}