<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderSellersTable extends Migration {

	public function up()
	{
		Schema::create('order_sellers', function(Blueprint $table) {
			$table->timestamps();
			$table->softDeletes();
			$table->timestamp('signedAt')->nullable();
			$table->timestamp('invitationReminderLastSentAt')->nullable();
			$table->timestamp('invitationLastSentAt')->nullable();
			$table->uuid('orderUuid')->index();
			$table->uuid('sellerUuid')->index();
		});
	}

	public function down()
	{
		Schema::drop('order_sellers');
	}
}