<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDisclosuresTable extends Migration {

	public function up()
	{
		Schema::create('disclosures', function(Blueprint $table) {
			$table->uuid('uuid')->primary()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->jsonb('inProgress')->nullable();
			$table->jsonb('inProgressPdfs')->nullable();
			$table->jsonb('pdfsInUse')->nullable();
			$table->jsonb('attachments')->nullable();
			$table->boolean('onboardingComplete')->default(false);
			$table->integer('stepIndex')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('disclosures');
	}
}