<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('properties_landlords', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('properties_landlords', function(Blueprint $table) {
			$table->foreign('landlord_id')->references('id')->on('landlords')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_user_id_foreign');
		});
		Schema::table('properties', function(Blueprint $table) {
			$table->dropForeign('properties_contract_id_foreign');
		});
		Schema::table('properties_landlords', function(Blueprint $table) {
			$table->dropForeign('properties_landlords_property_id_foreign');
		});
		Schema::table('properties_landlords', function(Blueprint $table) {
			$table->dropForeign('properties_landlords_landlord_id_foreign');
		});
	}
}