<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('offer_id')->unsigned();
			$table->integer('payment_method_id')->unsigned();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('billing_address');
			$table->string('phone');
			$table->string('country');
			$table->string('transaction_id')->nullable();
			$table->string('zip_code');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}