<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('title');
			$table->text('description');
			$table->integer('slots');
			$table->date('date');
			$table->time('time_from');
			$table->time('time_to');
			$table->string('link')->nullable();
			$table->string('location')->nullable();
			$table->string('map_link')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}