<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 191);
			$table->text('content');
			$table->string('image', 191);
			$table->double('price');
			$table->integer('branch_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}