<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Storestocks extends Model 
{

    protected $table = 'storestocks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('store_id', 'item_id', 'vendor_id', 'quantity', 'amount', 'date', 'user_id');

    public function vendor()
    {
        return $this->belongsTo('Vendors', 'vendor_id');
    }

    public function store()
    {
        return $this->belongsTo('Stores', 'store_id');
    }

    public function item()
    {
        return $this->belongsTo('Items', 'item_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}