<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFSDTable extends Migration {

	public function up()
	{
		Schema::create('FSD', function(Blueprint $table) {
			$table->increments('id');
			$table->string('file_id');
			$table->string('distributor_code');
			$table->string('distributor_name');
			$table->string('no_po');
			$table->string('status');
			$table->datetime('input_date');
			$table->string('pricelist_code');
			$table->string('requested_delivery_date');
			$table->string('order_type');
			$table->integer('top_reguler');
			$table->string('kubikasi_gimmick');
			$table->string('kubikasi');
			$table->string('item_code');
			$table->string('item_desc');
			$table->float('avg_sales_value');
			$table->float('avg_sales_karton');
			$table->float('stock_qty_karton');
			$table->float('stock_qty_pcs');
			$table->float('stock_nilai');
			$table->float('stock_intransit_karton');
			$table->float('stock_intransit_nilai');
			$table->float('order_rumus_karton');
			$table->float('order_rumus_nilai');
			$table->float('order_alokasi_karton');
			$table->float('order_alokasi_nilai');
			$table->float('total_order_karton');
			$table->float('total_order_nilai');
			$table->float('total_order_kubikasi');
			$table->float('adjusment_distributor_karton');
			$table->float('adjusment_distributor_nilai');
			$table->float('adjusment_nfi_karton');
			$table->float('adjusment_nfi_nilai');
			$table->float('order_final_karton');
			$table->float('order_final_nilai');
			$table->float('order_final_kubikasi');
			$table->float('stock_gudang');
			$table->float('stock_qty_karton_ed3');
			$table->float('stock_qty_pcs_ed3');
			$table->float('stock_qty_karton_ed6');
			$table->float('stock_qty_pcs_ed6');
			$table->float('stock_qty_karton_ed9');
			$table->float('stock_qty_pcs_ed9');
			$table->float('discount_retur');
			$table->float('cash_discount');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('FSD');
	}
}