<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Produitofpermis extends Model 
{

    protected $table = 'produitofpermis';
    public $timestamps = true;
    protected $fillable = array('quantite', 'pays_id', 'fournisseurimportateur_id', 'organismequarantaine_id', 'produit_id', 'permisimportation_id');

    public function pays()
    {
        return $this->belongsTo('App\Pays', 'pays_id');
    }

    public function fournisseurimportateur()
    {
        return $this->belongsTo('App\Fournisseurimportateur', 'fournisseurimportateur_id');
    }

    public function organismequarantaine()
    {
        return $this->belongsTo('App\Organismequarantaine', 'organismequarantaine_id');
    }

    public function permisimportation()
    {
        return $this->belongsTo('App\Permisimportation', 'permisimportation_id');
    }

    public function produit_id()
    {
        return $this->belongsTo('App\Produit', 'produit_id');
    }

}