<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->longText('name');
			$table->double('price');
			$table->date('date')->nullable();
			$table->smallInteger('minimum_age')->nullable();
			$table->smallInteger('lessons')->nullable();
			$table->smallInteger('hourse')->nullable();
			$table->smallInteger('max_student_per_class')->nullable();
			$table->integer('country_id');
			$table->integer('ages_group_id');
			$table->integer('city_id');
			$table->string('school_id');
			$table->date('start_date');
			$table->date('end_date');
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}