<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTypesTable extends Migration {

	public function up()
	{
		Schema::create('payment_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->text('description')->nullable();
			$table->string('phone_number', 20)->nullable();
			$table->string('bank_name', 100)->nullable();
			$table->string('IBAN', 100)->nullable();
			$table->string('branch', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payment_types');
	}
}