<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type', 128);
			$table->integer('user_id');
			$table->integer('related_id');
			$table->text('text');
			$table->integer('target_user_id');
			$table->timestamp('seen');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
			$table->timestamp('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}