<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100);
			$table->string('email', 100);
			$table->string('phone', 100);
			$table->string('country_code', 10);
			$table->integer('type')->default('0');
			$table->string('image', 100)->default('default.png');
			$table->string('work_certificate', 150)->default('default.png');
			$table->string('bank_name', 150);
			$table->string('account_number', 150);
			$table->string('bank_owner_name', 150);
			$table->string('iban', 150);
			$table->string('password', 150);
			$table->string('lang', 50)->default('ar');
			$table->integer('category_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('code', 50);
			$table->boolean('is_approved')->default(0);
			$table->boolean('is_active')->default(0);
			$table->boolean('is_available')->default(1);
			$table->double('wallet', 8,2)->default('0');
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}