<?php

namespace role;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'roles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function admin_roles()
	{
		return $this->hasOne('AdminUser', 'role_id');
	}

	public function role_permission_relation()
	{
		return $this->hasMany('RolePermission', 'role_id');
	}

}