<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->string('full_name', 100);
			$table->string('phone_number', 20);
			$table->string('alternate_number', 20)->nullable();
			$table->string('house_no', 50);
			$table->string('state', 50);
			$table->string('road_name', 200);
			$table->string('city', 100);
			$table->string('pincode', 20);
			$table->integer('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}