<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('type_id')->unsigned()->nullable();
			$table->string('name', 100);
			$table->string('email', 100);
			$table->string('national_id', 150);
			$table->string('phone', 100);
			$table->string('country_code', 10);
			$table->string('logo', 100)->default('default.png');
			$table->string('commercial_id', 150);
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('region_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->double('lat', 8.2);
			$table->double('lng', 8,2);
			$table->text('map_desc');
			$table->string('bank_name', 150);
			$table->string('account_number', 150);
			$table->string('iban', 150);
			$table->boolean('has_deposit')->default(1);
			$table->double('deposit', 8,2);
			$table->string('PASSW', 150);
			$table->string('lang', 50)->default('ar');
			$table->integer('category_id')->unsigned()->nullable();
			$table->string('code', 50);
			$table->boolean('is_approved')->default(0);
			$table->double('wallet', 8,2)->default('0');
			$table->double('service_rate', 8,2)->default('0.0');
			$table->double('speed_rate', 8,2)->default('0.0');
			$table->double('communication_rate', 8,2)->default('0.0');
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}