<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('paln_id')->unsigned()->nullable();
			$table->integer('provider_id')->unsigned()->nullable();
			$table->datetime('start_at');
			$table->datetime('end_at');
			$table->integer('pay_staus')->default('0');
			$table->integer('pay_type');
			$table->boolean('unsubscripe')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}